% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map.R
\name{oceProject}
\alias{oceProject}
\title{Wrapper to rgdal::project()}
\usage{
oceProject(
  xy,
  proj,
  inv = FALSE,
  use_ob_tran = FALSE,
  legacy = TRUE,
  passNA = FALSE
)
}
\arguments{
\item{xy, proj, inv, use_ob_tran, legacy}{As for the \code{\link[rgdal:project]{rgdal::project()}} function in the
\CRANpkg{rgdal} package.}

\item{passNA}{Logical value indicating whether to pass NA values into
\CRANpkg{rgdal}.  The default is \code{FALSE}, meaning that any NA
values are first converted to 0 before the calculation, and then
converted to NA afterwards. Setting this to \code{TRUE} produces
errors on the i386/windows platform, but it seems likely that a version
of \CRANpkg{rgdal} released after 1.3-9 may not have that error.}
}
\value{
A two-column matrix, with first column holding either
\code{longitude} or \code{x}, and second column holding either
\code{latitude} or \code{y}.
}
\description{
This function is used to isolate other oce functions from
changes to the \code{\link[rgdal:project]{rgdal::project()}} function in the \CRANpkg{rgdal}
package, which is used for calculations involved in both forward
and inverse map projections.
}
\details{
Some highlights of the evolving relationship with rgdal are:
\enumerate{
\item See https://github.com/dankelley/oce/issues/653#issuecomment-107040093
for the reason why oce switched from using \code{\link[rgdal:rawTransform]{rgdal::rawTransform()}},
to \code{\link[rgdal:project]{rgdal::project()}}, both functions provided by the
\CRANpkg{rgdal} package.
\item 2016 Apr: rgdal::project started returning named quantities
\item 2019 Feb: allowNAs_if_not_legacy was added in rgdal 1.3-9 to prevent
an error on i386/windows. However, using this argument imposes a
burden on users to update \CRANpkg{rgdal}, so the approach taken
here (by default, i.e. with \code{passNA=FALSE}) is to
temporarily switch NA data to 0, and then switch
back to NA after the calculation.
}
}
