% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oce.R
\name{oce.axis.POSIXct}
\alias{oce.axis.POSIXct}
\title{Oce Version of axis.POSIXct}
\usage{
oce.axis.POSIXct(side, x, at, tformat, labels = TRUE, drawTimeRange,
  abbreviateTimeRange = FALSE, drawFrequency = FALSE,
  cex = par("cex"), cex.axis = par("cex.axis"),
  cex.main = par("cex.main"), mar = par("mar"), mgp = par("mgp"),
  main = "", debug = getOption("oceDebug"), ...)
}
\arguments{
\item{side}{as for \code{\link{axis.POSIXct}}.}

\item{x}{as for \code{\link{axis.POSIXct}}.}

\item{at}{as for \code{\link{axis.POSIXct}}.}

\item{tformat}{as \code{format} for \code{\link{axis.POSIXct}} for now, but
may eventually have new features for multiline labels, e.g. day on one line
and month on another.}

\item{labels}{as for \code{\link{axis.POSIXct}}.}

\item{drawTimeRange}{Optional indication of whether/how to draw the time range
in the margin on the side of the the plot opposite the time axis. If this is
not supplied, it defaults to the value returned by
\code{\link{getOption}("oceDrawTimeRange")}, and if that option is not set,
it defaults to \code{TRUE}. No time range is drawn if \code{drawTimeRange} is \code{FALSE}.
If it is \code{TRUE}, the range will be shown. This range refers to
range of the x axis (not the data). The format of the elements of that range is set by
\code{\link{getOption}("oceTimeFormat")} (or with the default value
of an empty string, if this option has not been set). The timezone will
be indicated if the time range is under a week.  For preliminary work, it makes
sense to use \code{drawTimeRange=TRUE}, but for published work it can be better
to drop this label and indicate something about the time in the figure caption.}

\item{abbreviateTimeRange}{boolean, \code{TRUE} to abbreviate the second
number in the time range, e.g. dropping the year if it is the same in the
first number.}

\item{drawFrequency}{boolean, \code{TRUE} to show the frequency of sampling
in the data}

\item{cex}{size of labels on axes; see \code{\link[graphics]{par}}("cex").}

\item{cex.axis}{see \code{\link[graphics]{par}}("cex.axis").}

\item{cex.main}{see \code{\link[graphics]{par}}("cex.main").}

\item{mar}{value for \code{par(mar)} for axis}

\item{mgp}{value for \code{par(mgp)} for axis}

\item{main}{title of plot}

\item{debug}{a flag that turns on debugging.  Set to 1 to get a moderate
amount of debugging information, or to 2 to get more.}

\item{\dots}{as for \code{\link{axis.POSIXct}}.}
}
\value{
A vector of times corresponding to axis ticks is returned silently.
}
\description{
A specialized variant of \code{\link{axis.POSIXct}} that produces
results with less ambiguity in axis labels.
}
\details{
The tick marks are set automatically based on examination of the time range on
the axis. The scheme was devised by constructing test cases with a typical plot
size and font size, and over a wide range of time scales. In some categories,
both small tick marks are interspersed between large ones.

The user may set the format of axis numbers with the \code{tformat} argument.
If this is not supplied, the format is set based on the time span of the axis:

\itemize{

\item If this time span is less than a minute, the time axis labels are in
seconds (fractional seconds, if the interval is less than 2 seconds), with
leading zeros on small integers. (Fractional seconds are enabled with a trick:
the usual R format \code{"\%S"} is supplemented with a new format e.g.
\code{"\%.2S"}, meaning to use two digits after the decimal.)

\item If the time span exceeds a minute but is less than 1.5 days, the label
format is \code{"\%H:\%M:\%S"}.

\item If the time span exceeds 1.5 days but is less than 1 year, the format is
\code{"\%b \%d"} (e.g. Jul 15) and, again, the tick marks are set up for several
subcategories.

\item If the time span exceeds a year, the format is \code{"\%Y"}, i.e. the year
is displayed with 4 digits.

}

It should be noted that this scheme differs from the R approach in several
ways. First, R writes day names for some time ranges, in a convention that is
seldom seen in the literature. Second, R will write nn:mm for both HH:MM and
MM:SS, an ambiguity that might confuse readers. Third, the use of both large
and small tick marks is not something that R does.

Bear in mind that \code{tformat} may be set to alter the number format, but
that the tick mark scheme cannot (presently) be controlled.
}
\seealso{
This is used mainly by \code{\link{oce.plot.ts}}.
}
\author{
Dan Kelley
}
