% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map.R
\name{mapContour}
\alias{mapContour}
\title{Add Contours on a Existing map}
\usage{
mapContour(longitude = seq(0, 1, length.out = nrow(z)),
  latitude = seq(0, 1, length.out = ncol(z)), z, nlevels = 10,
  levels = pretty(range(z, na.rm = TRUE), nlevels), col = par("fg"),
  lty = par("lty"), lwd = par("lwd"))
}
\arguments{
\item{longitude}{vector of longitudes of points to be plotted, or an object of
class \code{topo} (see \code{\link{topo-class}}), in which case
\code{longitude}, \code{latitude} and \code{z} are inferred from that object.}

\item{latitude}{vector of latitudes of points to be plotted.}

\item{z}{matrix to be contoured.}

\item{nlevels}{number of contour levels, if and only if \code{levels} is not supplied.}

\item{levels}{vector of contour levels.}

\item{col}{line color.}

\item{lty}{line type.}

\item{lwd}{line width.}
}
\description{
Plot contours on an existing map.
}
\details{
Adds contour lines to an existing map, using \code{\link{mapLines}}.
The arguments are based on those to \code{\link{contour}} and
\code{\link{contourLines}}.
}
\section{Bugs}{

As with \code{\link{mapLines}}, long lines should be subdivided
into multiple segments so that e.g. great circle lines will be curved.
}

\examples{
\dontrun{
library(oce)
data(coastlineWorld)
par(mar=rep(1, 4))
## Arctic 100m, 2km, 3km isobaths, showing shelves and ridges.
mapPlot(coastlineWorld, latitudelim=c(60, 120), longitudelim=c(-130,-50),
        projection="+proj=stere +lat_0=90")
data(topoWorld)
lon <- topoWorld[['longitude']]
lat <- topoWorld[['latitude']]
z <- topoWorld[['z']]
mapContour(lon, lat, z, levels=c(-100, -2000, -3000), col=1:3, lwd=2)
}
}
\seealso{
A map must first have been created with \code{\link{mapPlot}}.

Other functions related to maps: \code{\link{lonlat2map}},
  \code{\link{lonlat2utm}}, \code{\link{map2lonlat}},
  \code{\link{mapArrows}}, \code{\link{mapAxis}},
  \code{\link{mapDirectionField}}, \code{\link{mapGrid}},
  \code{\link{mapImage}}, \code{\link{mapLines}},
  \code{\link{mapLocator}},
  \code{\link{mapLongitudeLatitudeXY}},
  \code{\link{mapPlot}}, \code{\link{mapPoints}},
  \code{\link{mapPolygon}}, \code{\link{mapScalebar}},
  \code{\link{mapText}}, \code{\link{mapTissot}},
  \code{\link{oceCRS}}, \code{\link{shiftLongitude}},
  \code{\link{usrLonLat}}, \code{\link{utm2lonlat}}
}
\author{
Dan Kelley
}
\concept{functions related to maps}
