% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClass.R
\name{defaultFlags}
\alias{defaultFlags}
\title{Suggest a default flag for good data}
\usage{
defaultFlags(object)
}
\arguments{
\item{object}{An oce object}
}
\value{
A vector of one or more flag values, or \code{NULL} if \code{object}
\code{metadata} slot lacks a \code{flagScheme} (as set by \code{\link{initializeFlagScheme}}),
or if it has a scheme that is not in the list provide in \dQuote{Description}.
}
\description{
\code{defaultFlag} tries to suggest a reasonable default \code{flag} scheme
for use by \code{\link{handleFlags}}. It does this by looking for an item
named \code{flagScheme} in the \code{metdata} slot of \code{object}.
If that is found, and if the scheme is recognized, then a numeric
vector is returned that indicates bad or questionable data. The recognized
schemes, and their defaults are as below; note that this is a very conservative
setup, retaining only data that are flagged as being good, while discarding
not just data that are marked as bad, but also data that are marked as
questionable.
\itemize{
\item for \code{argo}, the default is \code{flag=c(0, 2:9)}, i.e. retain only data flagged as 'passed_all_tests'
\item for \code{BODC}, the default is \code{flag=c(0, 2:9)}, i.e. retain only data flagged as 'good'
\item for \code{DFO}, the default is \code{flag=c(0, 2:9)}, i.e. retain only data flagged as 'appears_correct'
\item for \code{WHP bottle}, the default is \code{flag=c(1, 3:9)}, i.e. retain only data flagged as 'no_problems_noted'
\item for \code{WHP ctd}, the default is \code{flag=c(1, 3:9)}, i.e. retain only data flagged as 'acceptable'
}
}
\seealso{
Other functions relating to data-quality flags: \code{\link{handleFlags,adp-method}},
  \code{\link{handleFlags,argo-method}},
  \code{\link{handleFlags,ctd-method}},
  \code{\link{handleFlags,section-method}},
  \code{\link{handleFlags}},
  \code{\link{initializeFlagScheme,ctd-method}},
  \code{\link{initializeFlagScheme,oce-method}},
  \code{\link{initializeFlagScheme,section-method}},
  \code{\link{initializeFlagScheme}},
  \code{\link{initializeFlags,adp-method}},
  \code{\link{initializeFlags,oce-method}},
  \code{\link{initializeFlags}},
  \code{\link{setFlags,adp-method}},
  \code{\link{setFlags,ctd-method}},
  \code{\link{setFlags,oce-method}}, \code{\link{setFlags}}
}
\concept{functions relating to data-quality flags}
