% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map.R
\name{lonlat2map}
\alias{lonlat2map}
\title{Convert Longitude and Latitude to X and Y}
\usage{
lonlat2map(longitude, latitude, projection = "")
}
\arguments{
\item{longitude}{a vector containing decimal longitudes, or a list
containing items named \code{longitude} and \code{latitude}, in which case
the indicated values are used, and next argument is ignored.}

\item{latitude}{a vector containing decimal latitude (ignored if
\code{longitude} is a list, as described above).}

\item{projection}{optional indication of projection.  This must be character
string in the format used by the \code{rgdal} package;
see \code{\link{mapPlot}}.)}
}
\value{
A list containing \code{x} and \code{y}.
}
\description{
If a projection is already being used (e.g. as set by \code{\link{mapPlot}})
then only \code{longitude} and \code{latitude} should be given, and the
other arguments will be inferred by \code{lonlat2map}.  This is important
because otherwise, if a new projection is called for, it will ruin any
additions to the existing plot.
}
\examples{

\dontrun{
library(oce)
## Cape Split, in the Minas Basin of the Bay of Fundy
cs <- list(longitude=-64.49657, latitude=45.33462)
xy <- lonlat2map(cs, projection="+proj=merc")
map2lonlat(xy)
}
}
\seealso{
\code{mapLongitudeLatitudeXY} is a safer alternative, if a map has
already been drawn with \code{\link{mapPlot}}, because that function cannot
alter an existing projection. \code{\link{map2lonlat}} is an inverse to
\code{map2lonlat}.

Other functions related to maps: \code{\link{lonlat2utm}},
  \code{\link{map2lonlat}}, \code{\link{mapArrows}},
  \code{\link{mapAxis}}, \code{\link{mapContour}},
  \code{\link{mapDirectionField}}, \code{\link{mapGrid}},
  \code{\link{mapImage}}, \code{\link{mapLines}},
  \code{\link{mapLocator}},
  \code{\link{mapLongitudeLatitudeXY}},
  \code{\link{mapPlot}}, \code{\link{mapPoints}},
  \code{\link{mapPolygon}}, \code{\link{mapScalebar}},
  \code{\link{mapText}}, \code{\link{mapTissot}},
  \code{\link{oceCRS}}, \code{\link{shiftLongitude}},
  \code{\link{utm2lonlat}}
}
\author{
Dan Kelley
}
