% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{unabbreviateYear}
\alias{unabbreviateYear}
\title{Determine year from various abbreviations}
\usage{
unabbreviateYear(year)
}
\arguments{
\item{year}{a year, or vector of years, possibly abbreviated}
}
\description{
Various data files may contain various abbreviations for years.  For
example, 99 refers to 1999, and 8 refers to 2008.  Sometimes, even 108
refers to 2008 (the idea being that the "zero" year was 1900).  This
function deals with the three cases mentioned.  It will fail if someone
supplies 60, meaning year 2060 as opposed to 1960.
}
\examples{

fullYear <- unabbreviateYear(c(99, 8, 108))
}
\seealso{
Other things related to time: \code{\link{ctimeToSeconds}},
  \code{\link{julianCenturyAnomaly}},
  \code{\link{julianDay}}, \code{\link{numberAsHMS}},
  \code{\link{numberAsPOSIXct}},
  \code{\link{secondsToCtime}}
}
\author{
Dan Kelley
}
