% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctd.R
\docType{class}
\name{ctd-class}
\alias{ctd-class}
\title{Class to Store CTD (or general hydrographic) Data}
\description{
Class to store hydrographic data such as measured with a CTD (conductivity,
temperature, depth) instrument, or with other systems that produce
similar data.  Data repositories may store conductivity, temperature
and depth, as in the instrument name, but it is also common to store
salinity, temperature and pressure instead (or in addition). For this
reason, \code{ctd} objects are required to hold \code{salinity},
\code{temperature} and \code{pressure} in their \code{data} slot,
with other data being optional. Formulae are available for converting
between variants of these data triplets, e.g. \code{\link{swSCTp}}
can calculate \code{salinity} given \code{conductivity}, \code{temperature}
and \code{pressure}, and these are used by the main functions that
create \code{ctd} objects. For example, if \code{\link{read.ctd.sbe}}
is used to read a Seabird file that contains only conductivity, temperature
and pressure, then that function will automatically append a data
item to hold salinity.  \code{\link{as.ctd}} acts similarly. The result
this is that all \code{ctd} objects hold \code{salinity},
\code{temperature} and \code{pressure}, which are henceforth called
the three basic quantities.
}
\details{
Different units and scales are permitted for the three basic quantities, and
most \code{oce} functions check those units and scales before
doing calculations (e.g. of seawater density), because those calculations
demand certain units and scales. The way this is handled is that the
accessor function \code{\link{[[,ctd-method}} returns values in standardized
form. For example, a \code{ctd} object might hold temperature defined on the
IPTS-68 scale, but e.g. \code{ctd[["temperature"]]} returns a value on the ITS-90
scale. (The conversion is done with \code{\link{T90fromT68}}.)  Similarly,
pressure may be stored in either dbars or PSI, but e.g. \code{ctd[["pressure"]]}
returns a value in dbars, after multiplying by 0.689476 if the value is
stored in PSI. Luckily, there is (as of early 2016) only one salinity scale in
common use in data files, namely PSS-78.

The TEOS-10 notation for these quantities also works, with \code{ctd[["SP"]]},
\code{ctd[["t"]]} and \code{ctd[["p"]]} returning identical values to those
returned for the longer names.

After the names listed above have been checked, the remaining names in the
\code{data} slot are checked using \code{\link{pmatch}}, so that e.g.
\code{ctd[["sal"]]} will recover practical \code{salinity}, \code{ctd[["sc"]]}
will recover \code{scan} (if it exists), etc.
}
\section{Accessing data}{

Data may be extracted with \code{\link{[[,ctd-method}} and inserted
with \code{\link{[[<-,ctd-method}}. As noted above, \code{\link{[[,ctd-method}}
returns temperature in the ITS-90 scale and pressure in dbar, regardless of the
scale and unit of the data within the object. Type \code{?"[[,ctd-method"}
or \code{?"[[<-,ctd-method"} to learn more.

Depth is accessed with e.g. \code{ctd[["depth"]]}, while its negative, the
vertical coordinate, is accessed with e.g.  \code{ctd[["z"]]}; note that these
are calculated using \code{\link{swDepth}} and \code{\link{swZ}}, and that any
values that may have been read in a data file are ignored.

Potential temperature defined according to UNESCO-1980 is calculated with
\code{ctd[["theta"]]} or \code{ctd[["potential temperature"]]}.  Salinity is
retrieved with \code{ctd[["S"]]} or \code{ctd[["salinity"]]}.

Conservative Temperature defined according to TEOS-2010 is calculated with
\code{ctd[["CT"]]} or \code{ctd[["conservative temperature"]]}.  Absolute
salinity is calculated with \code{ctd[["SA"]]} or \code{ctd[["absolute
salinity"]]}. Note that the salinity calculation requires a latitude and
longitude, and if the \code{ctd} object lacks those data, the values 300E and
30N will be used as a default.

The square of buoyancy frequency is retrieved with \code{ctd[["N2"]]} or
\code{\link{swN2}}, density ratio with \code{ctd[["Rrho"]]} and spiciness with
\code{ctd[["spice"]]}.
}

\section{Extracting values}{

Items stored in the object may be altered with e.g.  \code{ctd[["salinity"]]
  <- rep(35,10)}.  For obvious reasons, this does not work with derived
quantities such as conservative temperature, etc.
}

\section{Reading/creating data}{

A file containing CTD profile data may be read with
\code{\link{read.ctd}}, and a CTD object can also be created with
\code{\link{as.ctd}}.  See \code{\link{read.ctd}} for references on data
formats used in CTD files. Data can also be assembled into
\code{ctd} objects with \code{\link{as.ctd}}.

Statistical summaries are provided by \code{\link{summary,ctd-method}}, while
\code{\link{show}} displays an overview.

CTD objects may be plotted with \code{\link{plot,ctd-method}}, which does much of its
work by calling \code{\link{plotProfile}} or \code{\link{plotTS}}, both of
which can also be called by the user, to get fine control over the plots.

A CTD profile can be isolated from a larger record with \code{\link{ctdTrim}},
a task made easier when \code{\link{plotScan}} is used to examine the results.
Towyow data can be split up into sets of profiles (ascending or descending)
with \code{\link{ctdFindProfiles}}.  CTD data may be smoothed and/or cast onto
specified pressure levels with \code{\link{ctdDecimate}}.

As with all oce objects, low-level manipulation may be done with
\code{\link{oceSetData}} and \code{\link{oceSetMetadata}}. Additionally,
many of the contents of CTD objects may be altered with the \code{\link{[[,ctd-method}} scheme
discussed above, and skilled users may also manipulate the contents directly.
}

\seealso{
Other things related to \code{ctd} data: \code{\link{[[,ctd-method}},
  \code{\link{[[<-,ctd-method}}, \code{\link{as.ctd}},
  \code{\link{cnvName2oceName}}, \code{\link{ctdDecimate}},
  \code{\link{ctdFindProfiles}}, \code{\link{ctdRaw}},
  \code{\link{ctdTrim}}, \code{\link{ctd}},
  \code{\link{handleFlags,ctd-method}},
  \code{\link{plot,ctd-method}}, \code{\link{plotProfile}},
  \code{\link{plotScan}}, \code{\link{plotTS}},
  \code{\link{read.ctd.itp}}, \code{\link{read.ctd.odf}},
  \code{\link{read.ctd.sbe}},
  \code{\link{read.ctd.woce.other}},
  \code{\link{read.ctd.woce}}, \code{\link{read.ctd}},
  \code{\link{subset,ctd-method}},
  \code{\link{summary,ctd-method}},
  \code{\link{woceNames2oceNames}}, \code{\link{write.ctd}}

Other classes provided by \code{oce}: \code{\link{adp-class}},
  \code{\link{adv-class}}, \code{\link{argo-class}},
  \code{\link{bremen-class}}, \code{\link{cm-class}},
  \code{\link{coastline-class}},
  \code{\link{echosounder-class}},
  \code{\link{lisst-class}}, \code{\link{lobo-class}},
  \code{\link{met-class}}, \code{\link{oce-class}},
  \code{\link{odf-class}}, \code{\link{rsk-class}},
  \code{\link{sealevel-class}},
  \code{\link{section-class}}, \code{\link{topo-class}},
  \code{\link{windrose-class}}
}
\author{
Dan Kelley
}
