% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{matrixShiftLongitude}
\alias{matrixShiftLongitude}
\title{Rearrange areal matrix so Greenwich is near the centre}
\usage{
matrixShiftLongitude(m, longitude)
}
\arguments{
\item{m}{The matrix to be modified.}

\item{longitude}{A vector containing the longitude in the 0-360 convention. If missing, this is constructed to range from 0 to 360, with as many elements as the first index of \code{m}.}
}
\value{
A list containing \code{m} and \code{longitude}, both rearranged as appropriate.
}
\description{
Sometimes datasets are provided in matrix form, with first
index corresponding to longitudes ranging from 0 to 360.
\code{matrixShiftLongitude} cuts such matrices at
longitude=180, and swaps the pieces so that the dateline
is at the left of the matrix, not in the middle.
}
\seealso{
\code{\link{shiftLongitude}} and \code{\link{standardizeLongitude}}.
}

