% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coastline.R
\name{download.coastline}
\alias{download.coastline}
\title{Download a coastline File}
\usage{
download.coastline(resolution, item = "coastline", destdir = ".", destfile,
  server = "naturalearth", debug = getOption("oceDebug"))
}
\arguments{
\item{resolution}{A character value specifying the desired resolution. The permitted
choices are \code{"10m"} (for 1:10M resolution, the most detailed),
\code{"50m"} (for 1:50M resolution)
and \code{"110m"} (for 1:110M resolution). If \code{resolution} is not supplied,
\code{"50m"} will be used.}

\item{item}{A character value indicating the quantity to be downloaded.
This is normally one of \code{"coastline"}, \code{"land"}, \code{"ocean"},
\code{"rivers_lakes_centerlines"}, or \code{"lakes"}, but the NaturalEarth
server has other types, and advanced users can discover their names by inspecting
the URLs of links on the NaturalEarth site, and use them for \code{item}.
If \code{item} is not supplied, it defaults to \code{"coastline"}.}

\item{destdir}{Optional string indicating the directory in which to store
downloaded files. If not supplied, \code{"."} is used, i.e. the data file
is stored in the present working directory.}

\item{destfile}{Optional string indicating the name of the file.
If not supplied, the file name is constructed from the other
parameters of the function call, so subsequent calls with the same
parameters will yield the same result, thus providing the key
to the caching scheme.}

\item{server}{A character value specifying the server that is to suppply
the data. At the moment, the only permitted value is \code{"naturalearth"},
which is the default if \code{server} is not supplied.}

\item{debug}{an integer specifying whether debugging information is
to be printed during the processing. This is a general parameter that
is used by many \code{oce} functions. Generally, setting \code{debug=0}
turns off the printing, while higher values suggest that more information
be printed.}
}
\value{
A character value indicating the filename of the result; if
there is a problem of any kind, the result will be the empty
string.
}
\description{
Constructs a query to the NaturalEarth server [1] to download coastline
data (or lake data, river data, etc) in any of three resolutions.
}
\section{Warning}{

All of the \code{download.*} functions are subject to change through the
autumn of 2016. The plan is to create individual functions
as needs arise in everyday work, thereby discovering patterns of 
arguments that might make sense more generally. Therefore, it is likely
that argument order (and even name) may change up until approximately
December 2016. Users are advised to refer to arguments by name,
i.e. not to rely on their order, and they are asked for patience,
because argument names and defaults may vary through the early development.
}
\examples{
\dontrun{
library(oce)
# User must create directory ~/data/coastline first.
# As of September 2016, the downloaded file, named
# "ne_50m_coastline.zip", occupies 443K bytes.
filename <- download.coastline(destdir="~/data/coastline")
coastline <- read.coastline(filename)
plot(coastline)
}

}
\references{
1. The NaturalEarth server is at \url{http://www.naturalearthdata.com}
}
\seealso{
The work is done with \code{\link[utils]{download.file}}.

Other functions that download files: \code{\link{download.amsr}},
  \code{\link{download.topo}}

Other things related to \code{coastline} data: \code{\link{[[,coastline-method}},
  \code{\link{[[<-,coastline-method}},
  \code{\link{as.coastline}},
  \code{\link{coastline-class}},
  \code{\link{coastlineBest}}, \code{\link{coastlineCut}},
  \code{\link{coastlineWorld}},
  \code{\link{plot,coastline-method}},
  \code{\link{read.coastline.openstreetmap}},
  \code{\link{read.coastline.shapefile}},
  \code{\link{subset,coastline-method}},
  \code{\link{summary,coastline-method}}
}

