% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oce.R
\name{oce.write.table}
\alias{oce.write.table}
\title{Write the Data Portion of Object to a File}
\usage{
oce.write.table(x, file = "", ...)
}
\arguments{
\item{x}{an \code{oce} object that contains a \code{data} table.}

\item{file}{file name, as passed to \code{\link[utils]{write.table}}.  Use
\code{""} to get a listing in the terminal window.}

\item{...}{optional arguments passed to \code{\link[utils]{write.table}}.}
}
\value{
The value of \code{\link[utils]{write.table}} is returned.
}
\description{
The output has a line containing the names of the columns in \code{x$data},
each enclosed in double quotes.  After that line are lines for the data
themselves.  The default is to separate data items by a single space
character, but this can be altered by using a \code{sep} argument in the
\code{...} list (see \code{\link[utils]{write.table}}).
}
\details{
This function is little more than a thin wrapper around
\code{\link[utils]{write.table}}, the only difference being that row names
are omitted here, making for a file format that is more conventional in
Oceanography.
}
\author{
Dan Kelley
}
\seealso{
\code{\link[utils]{write.table}}, which does the actual work.
}

