\name{julianDay}

\alias{julianDay}

\title{Convert a POSIXt time to a Julian day}

\description{Convert a POSIXt time to a Julian day}

\usage{julianDay(t, year, month, day, hour, min, sec, tz="UTC")}

\arguments{

    \item{t}{a time, in POSIXt format, e.g. as created by
        \code{\link{as.POSIXct}}, \code{\link{as.POSIXlt}}, or
        \code{\link{numberAsPOSIXct}}.  If this is provided, the other
        arguments are ignored.}

    \item{year}{year, to be provided along with \code{month}, etc., if \code{t} is not provided.}

    \item{month}{month, numbered with January being 1.}

    \item{day}{day in month, starting at 1.}

    \item{hour}{hour of day.}

    \item{min}{minute of hour}

    \item{sec}{second of hour}

    \item{tz}{timezone}

}

\details{The method is taken from Chapter 3 of Meeus (1982).  It should be
    noted that Meeus and other astronomical treatments use fractional days,
    whereas the present code follows the R convention of specifying days in
    whole numbers, with hours, minutes, and seconds also provided as necessary.
    Conversion is simple, as illustrated in the example for 1977 April 26.4,
    for which Meeus calculates julian day 2443259.9.  Note that the R
    documentation for \code{\link{julian}} suggests another formula, but the
    point of the present function is to match the other Meeus formulae, so that
    suggestion is ignored here.}

\value{A Julian-Day number, in astronomical convention as explained in Meeus.}

\examples{
t <- ISOdatetime(1977, 4, 26, hour=0, min=0, sec=0, tz="ET")+0.4*86400
jd <- julianDay(t)
cat(format(t), "is Julian Day", format(jd, digits=14), "\n")
}

\author{Dan Kelley}

\references{Meeus, Jean, 1982.  Astronomical formuae for Calculators.
    Willmann-Bell. Richmond VA, USA. 201 pages}

\keyword{misc}

