% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oblique_survival_forest_predictSurvProb.R
\name{predictSurvProb.orsf}
\alias{predictSurvProb.orsf}
\title{Compute predictions using an oblique random survival forest.}
\usage{
\method{predictSurvProb}{orsf}(object, newdata, times, ...)
}
\arguments{
\item{object}{A fitted model from which to extract predicted survival probabilities}

\item{newdata}{A data frame containing predictor variable combinations for which to compute predicted survival probabilities.}

\item{times}{A vector of times in the range of the response variable, e.g. times when the response is a survival object, at which to return the survival probabilities.}

\item{...}{Additional arguments that are passed on to the current method.}
}
\value{
A matrix of survival probabilities containing 1 row for each observation and 1 column for each value in times.
}
\description{
Compute predictions using an oblique random survival forest.
}
\examples{
\dontrun{
data("pbc",package='survival')
pbc$status[pbc$status>=1]=pbc$status[pbc$status>=1]-1
pbc$id=NULL
fctrs<-c('trt','ascites','spiders','edema','hepato','stage')
for(f in fctrs)pbc[[f]]=as.factor(pbc[[f]])
pbc=na.omit(pbc)

orsf=ORSF(data=pbc,ntree=30)
times=seq(365, 365*4,length.out = 10)

predict(orsf,newdata=pbc[c(1:5),],times=times)
}
}
