% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print_methods.R
\name{print_design}
\alias{print_design}
\title{Prints the design}
\usage{
print_design(design, print_all = FALSE)
}
\arguments{
\item{design}{A matrix with rows equal to the number of rules and columns
equal to the number of actions}

\item{print_all}{If TRUE prints information on the number of iterations and 
and whether all design conditions were met. Default is FALSE}
}
\description{
Takes a design or list of designs and prints them to the console. To store a 
design, please see \code{\link{save_design}}. Depending on the print options,
additional text is provided with information on the considered rule and/or
the design generation process.
}
\examples{
design_opt_input <- list(rules = 4, 
                         actions = 5)

design <- generate_designs(design_opt_input)

print_design(design)
print_design(design, TRUE)

}
