% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_entropy.R
\name{calc_entropy}
\alias{calc_entropy}
\title{Calculate Shannon's Entropy}
\usage{
calc_entropy(design, priors = NULL)
}
\arguments{
\item{design}{A matrix with rows equal to the number of rules and columns
equal to the number of actions or a list of such matrices.}

\item{priors}{A vector of prior values. If the design is a list of matrices,
priors can be a matrix with rows equal to the length of the design and columns
equal to the number of rules.}
}
\value{
Returns a vector of entropies for each possible action with the
following attributes:
\enumerate{
  \item design
  \item priors
  \item pr_aj_rk
  \item pr_rk_aj
}
}
\description{
The function calculates Shannon's Entropy. The function is
meant for internal use only. To calculate the entropy for each action in the 
design, please use the wrapper function \code{\link{calculate_entropy}}
}
