% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualisation.R
\name{plotEventMap}
\alias{plotEventMap}
\title{Plot limit order event map.}
\usage{
plotEventMap(events, start.time = min(events$timestamp),
  end.time = max(events$timestamp), price.from = NULL, price.to = NULL,
  volume.from = NULL, volume.to = NULL, volume.scale = 1)
}
\arguments{
\item{events}{Limit order \code{\link{events}} data.frame.}

\item{start.time}{Plot events from this time onward.}

\item{end.time}{Plot events up until this time.}

\item{price.from}{Plot events with price levels >= this value.}

\item{price.to}{Plot events with price levels <= this value.}

\item{volume.from}{Plot events with volume >= this value relevant to
volume.scale}

\item{volume.to}{Plot events with volume <= this value relevant to
volume scale.}

\item{volume.scale}{Volume scale factor.}
}
\description{
Generates a visualisation of limit order events (excluding market and market
limit orders).
}
\details{
\itemize{
  \item Ask side orders = red.
  \item Bid side orders = blue.
  \item Volume of order determines size of circle.
  \item Opaque = volume was added.
  \item Transparent = volume was removed.
}
}
\examples{

\dontrun{

# plot all orders 
with(lob.data, plotEventMap(events))
}

# 1 hour of activity and re-scale the volume
with(lob.data, plotEventMap(events,
    start.time=as.POSIXct("2015-05-01 03:30:00.000", tz="UTC"),
    end.time=as.POSIXct("2015-05-01 04:00:00.000", tz="UTC"),
    volume.scale=10^-8))

# 15 minutes of activity >= 5 (re-scaled) volume within price range
# $ [220, 245]
with(lob.data, plotEventMap(events,
    start.time=as.POSIXct("2015-05-01 03:30:00.000", tz="UTC"),
    end.time=as.POSIXct("2015-05-01 03:45:00.000", tz="UTC"),
    price.from=220,
    price.to=245,
    volume.from=5,
    volume.scale=10^-8))

}
\author{
phil
}

