% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correct_image_dim.R
\name{correct_image_dim}
\alias{correct_image_dim}
\title{Image Dimension Correction}
\usage{
correct_image_dim(image, dim = 3)
}
\arguments{
\item{image}{volume of class \code{\link{nifti}}}

\item{dim}{scalar value of desired image dimension}
}
\value{
Returns a volume of class \code{\link{nifti}} of desired dimension.
}
\description{
This function takes an image and drops dimensions
until the volume is a user specified dimension.
}
\examples{
\dontrun{
library(neurobase)
flair <- readnii('path/to/flair', reorient = FALSE)
flair <- correct_image_dim(flair, dim = 3)
}
}
