% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api_embeddings.R
\name{embeddings_object_request}
\alias{embeddings_object_request}
\title{API embeddings: get embedding object}
\usage{
embeddings_object_request(api_key, index, embedding, object)
}
\arguments{
\item{api_key}{string, OpenAI API key
(see https://platform.openai.com/account/api-keys)}

\item{index}{integer, The index of the embedding in the list of embeddings.}

\item{embedding}{double vector, the embedding vector, which is a "list of floats". The length of vector depends on
the model as listed in the embedding guide.}

\item{object}{string, the object type, which is always "embedding".}
}
\value{
\link[httr]{content} of the httr \link[httr]{response} object
or SimpleError (\link[base]{conditions}) enhanced with
two additional fields: `status_code` (response$status_code)
and `message_long` (built on response content)
}
\description{
Represents an embedding vector returned by embedding endpoint. To get more details, visit
https://platform.openai.com/docs/api-reference/embeddings/object
https://platform.openai.com/docs/guides/embeddings
}
