% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correlation_test.R
\name{correlation_test}
\alias{correlation_test}
\title{Permutation test of pairwise correlations}
\usage{
correlation_test(pca_data, n = 100, cor.method = "pearson")
}
\arguments{
\item{pca_data}{dataframe or matrix containing only continuous variables.
(as accepted by the \code{prcomp} function.)}

\item{n}{the number of times (integer) to permute that data. \strong{Warning:}
high values will take a long time to compute. Default: 100.}

\item{cor.method}{method to use for correlations (default = "pearson").
Alternative is "spearman" (see \code{?cor.test}).}
}
\value{
object of class \code{correlation_test}, with attributes:
\itemize{
\item \verb{$permuted_correlations} A tibble of length n of pairs from the original
data, their correlations, and the significance of each correlation (as
p-values).
\item \verb{$actual_correlations} the correlations of each pair of variables
in the original data and their significance (as p-values).
\item \verb{$iterations} the number of permutations carried out.
\item \verb{$cor_method} the form of correlation used.
}
}
\description{
Permute data a given number (n) of times, collecting pairwise correlations
and testing them for significance. See \code{\link[=plot_correlation_magnitudes]{plot_correlation_magnitudes()}} and
\code{\link[=plot_correlation_counts]{plot_correlation_counts()}} for plotting functions which take the output of
this function.
}
\examples{
  # get a small sample of random intercepts.
  pca_data <- onze_intercepts |>
    dplyr::select(-speaker) |>
    dplyr::slice_sample(n=10)

  # apply correlation test with 10 permutations.
  # actual use requires at least 100.
  cor_test <- correlation_test(pca_data, n = 10, cor.method = 'pearson')
  # Return summary of significant correlations
  summary(cor_test)

  # use spearman correlation instead.
  cor_test_spear <- correlation_test(pca_data, n = 10, cor.method = 'spearman')
}
