% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nzilbb.labbcat.R
\name{getMatchingGraphIds}
\alias{getMatchingGraphIds}
\title{Gets a list of IDs of graphs that match a particular pattern.}
\usage{
getMatchingGraphIds(labbcat.url, expression, pageLength = NULL,
  pageNumber = NULL, order = NULL)
}
\arguments{
\item{labbcat.url}{URL to the LaBB-CAT instance}

\item{expression}{An expression that determines which graphs match}

\item{pageLength}{The maximum number of IDs to return, or null to return all}

\item{pageNumber}{The zero-based page number to return, or null to return the first page}

\item{order}{An expression that determines the order the graphs are
listed in}
}
\value{
A list of graph IDs (i.e. transcript names)
}
\description{
Gets a list of IDs of graphs (i.e. transcript names) that match a
particular pattern.
}
\details{
The results can be exhaustive, by omitting pageLength and
pageNumber, or they  can be a subset (a 'page') of results, by
given pageLength and pageNumber values.

The order of the list can be specified.  If ommitted, the graphs
are listed in ID order.

The expression language is currently not well defined, but
expressions such as those in the examples can be used.
}
\examples{
\dontrun{
## define the LaBB-CAT URL
labbcat.url <- "https://labbcat.canterbury.ac.nz/demo/"

## Get all transcripts whose names start with "BR"
transcripts <- getMatchingGraphIds(labbcat.url, "id MATCHES 'BR.+'")

## Get the first twenty transcripts in the "QB" corpus
transcripts <- getMatchingGraphIds(
        labbcat.url, "my('corpus').label = 'QB'", 20, 0)

## Get the second transcript that has "QB247_Jacqui" as a speaker
transcripts <- getMatchingGraphIds(
        labbcat.url, "'QB247_Jacqui' IN labels('who')", 1, 1)

## Get all transcripts whose names start with "BR" and have "QB247_Jacqui" as a speaker,
## in word-count order 
transcripts <- getMatchingGraphIds(
        labbcat.url, "my('corpus').label = 'QB' AND 'QB247_Jacqui' IN labels('who')", 1, 1,
        "my('transcript_word_count').label")
}

}
\keyword{expression}
\keyword{graph}
\keyword{transcript}
