% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nzilbb.labbcat.R
\name{getAvailableMedia}
\alias{getAvailableMedia}
\title{List the media available for the given graph.}
\usage{
getAvailableMedia(labbcat.url, id)
}
\arguments{
\item{labbcat.url}{URL to the LaBB-CAT instance}

\item{id}{A graph ID (i.e. transcript name)}
}
\value{
A named list of media files available for the given graph, with members:
\enumerate{
 \item{trackSuffix The track suffix of the media}
 \item{mimeType The MIME type of the file}
 \item{url URL to the content of the file}
 \item{name Name of the file}
}
}
\description{
List the media available for the given graph.
}
\examples{
\dontrun{
## define the LaBB-CAT URL
labbcat.url <- "https://labbcat.canterbury.ac.nz/demo/"

## List the media files available for BR2044_OllyOhlson.eaf
media <- getAvailableMedia(labbcat.url, "BR2044_OllyOhlson.eaf")
}

}
\seealso{
\link{getGraphIds}
}
\keyword{audio}
\keyword{media}
