% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nyc_period_attendance_reporting.R
\name{nyc_period_attendance_reporting}
\alias{nyc_period_attendance_reporting}
\title{Statistical Summary Period Attendance Reporting (PAR)}
\source{
NYC Open Data: <https://data.cityofnewyork.us/Education/Statistical-Summary-Period-Attendance-Reporting-PA/hrsu-3w2q/about_data>
}
\usage{
nyc_period_attendance_reporting(limit = 10000, filters = list())
}
\arguments{
\item{limit}{Number of rows to retrieve (default = 10,000).}

\item{filters}{Optional list of field-value pairs to filter results.}
}
\value{
A tibble containing Period Attendance data.
}
\description{
Downloads Statistical Summary Period Attendance Reporting (PAR) from NYC Open Data.
}
\details{
Statistical report on attendance by borough, grade.
Alternate views of same data by grade level and enrollment (register).
All students including YABC, adults, LYFE babies and charters, home instruction, home/hospital, CBO UPK.
}
\examples{
# Quick example (fetch 10 rows)
small_sample <- nyc_period_attendance_reporting(limit = 10)
head(small_sample)

\donttest{
nyc_period_attendance_reporting(limit = 5000)
nyc_period_attendance_reporting(filters = list(boro = "X"))
}
}
