% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/partition.R
\name{partition}
\alias{partition}
\title{Convert columns of data frame to Boolean or fuzzy sets}
\usage{
partition(
  .data,
  .what = everything(),
  ...,
  .breaks = NULL,
  .labels = NULL,
  .na = TRUE,
  .keep = FALSE,
  .method = "crisp",
  .right = TRUE
)
}
\arguments{
\item{.data}{the data frame to be processed}

\item{.what}{a tidyselect expression (see
\href{https://tidyselect.r-lib.org/articles/syntax.html}{tidyselect syntax})
specifying the columns to be transformed}

\item{...}{optional other tidyselect expressions selecting additional
columns to be processed}

\item{.breaks}{for numeric columns, this has to be either an integer scalar
or a numeric vector. If \code{.breaks} is an integer scalar, it specifies
the number of resulting intervals to break the numeric column to
(for \code{.method="crisp"}) or the number of target fuzzy sets (for
\code{.method="triangle"} or \verb{.method="raisedcos}). If \code{.breaks} is a vector,
the values specify the borders of intervals (for \code{.method="crisp"})
or the breaking points of fuzzy sets.}

\item{.labels}{character vector specifying the names used to construct
the newly created column names. If \code{NULL}, the labels are generated
automatically.}

\item{.na}{if \code{TRUE}, an additional logical column is created for each
source column that contains \code{NA} values. For column named \code{x}, the
newly created column's name will be \code{x=NA}.}

\item{.keep}{if \code{TRUE}, the original columns being transformed remain
present in the resulting data frame.}

\item{.method}{The method of transformation for numeric columns. Either
\code{"crisp"}, \code{"triangle"}, or \code{"raisedcos"} is required.}

\item{.right}{If \code{.method="crisp"}, this argument specifies if the
intervals should be closed on the right (and open on the left) or
vice versa.}
}
\value{
A tibble created by transforming \code{.data}.
}
\description{
Convert the selected columns of the data frame into either dummy
logical columns (for logicals and factors), or into membership degrees
of fuzzy sets (for numeric columns), while leaving the remaining columns
untouched. Each column selected for transformation typically yields in
multiple columns in the output.
}
\details{
Concretely, the transformation of each selected column is performed as
follows:
\itemize{
\item logical column \code{x} is transformed into pair of logical columns,
\code{x=TRUE} and\code{x=FALSE};
\item factor column \code{x}, which has levels \code{l1}, \code{l2}, and \code{l3}, is transformed
into three logical columns named \code{x=l1}, \code{x=l2}, and \code{x=l3};
\item numerical column\code{x} is transformed accordingly to \code{.method} argument:
\itemize{
\item if \code{.method="crisp"}, the column is first transformed into a factor
with intervals as factor levels and then it is processed as a factor
(see above);
\item for other \code{.method} (\code{triangle} or \code{raisedcos}), several new columns
are created, where each column has numeric values from the interval
\eqn{[0,1]} and represents a certain fuzzy set (either triangular or
raised-cosinal).
Details of transformation of numeric columns can be specified with
additional arguments (\code{.breaks}, \code{.labels}, \code{.right}).
}
}
}
\author{
Michal Burda
}
