% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/likelihood.R
\name{likelihood_fn}
\alias{likelihood_fn}
\title{Likelihood function for the GrOU process with penalty.}
\usage{
likelihood_fn(
  times,
  data,
  thresholds,
  lambda = NA,
  reg = "l1",
  div = 1e+05,
  gamma = NA,
  use_scaling = FALSE,
  mle = NA,
  log = TRUE
)
}
\arguments{
\item{times}{Times at which data is given}

\item{data}{Values to compute the MLE with.}

\item{thresholds}{Jump threshold values.}

\item{lambda}{Penalty parameter (defaults to \code{NA} with no penalty).}

\item{reg}{Type of penalty (\code{l1}, \code{l2} or \code{adaptive}).}

\item{div}{Batch size/divisor to avoid large memory allocation.}

\item{gamma}{Adaptive MLE scaling parameter.}

\item{use_scaling}{Brownian motion covariance matrix scaling
in the likelihood.}

\item{mle}{MLE for \code{adaptive} regularisation.}

\item{log}{Log-scale for the likelihood or not (defaults to \code{FALSE}).}
}
\value{
(Log)likelihood of the GrOU process with penalty.
}
\description{
Likelihood function for the GrOU process with penalty.
}
\examples{
n <- 1000
d <- 10
times <- seq(n)
delta_time <- 0.01
beta_value <- 0.499
noise <- matrix(rnorm(n * d, sd = sqrt(delta_time)), ncol = d)
data <- construct_path(
  diag(d),
  noise = noise, y_init = rep(0, d), delta_time = delta_time
)
thresholds <- rep(delta_time^beta_value, d)
loglik <- likelihood_fn(
  times = times, data = data,
  thresholds = thresholds,
  lambda = 1, div = 1e2
)
loglik(diag(d))
}
