% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/path_generation.R
\name{construct_path}
\alias{construct_path}
\title{Generates a single Graph Ornstein-Uhlenbeck path with the given
network topology (\code{nw_topo}), noise increments (\code{noise}),
initial values (\code{y_init}) and unique time difference (\code{delta_time}).}
\usage{
construct_path(nw_topo, noise, y_init, delta_time)
}
\arguments{
\item{nw_topo}{Graph topology or adjacency matrix.}

\item{noise}{Noise increments to apply.}

\item{y_init}{Start value.}

\item{delta_time}{Time step.}
}
\value{
A matrix corresponding to a path realisation of the GrOU process.
The shape is dictated by the \code{noise} argument.
}
\description{
Generates a single Graph Ornstein-Uhlenbeck path with the given
network topology (\code{nw_topo}), noise increments (\code{noise}),
initial values (\code{y_init}) and unique time difference (\code{delta_time}).
}
\examples{
n <- 100
d <- 10
delta_time <- 0.01
noise <- matrix(rnorm(n * d), ncol = d)
construct_path(diag(10), noise, d, delta_time)
}
