% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{nsw}
\alias{nsw}
\alias{lga_nsw}
\alias{poa_nsw}
\title{Geospatial data of the New South Wales administrative boundaries.}
\format{
An object of class \code{sfc_MULTIPOLYGON} (inherits from \code{sfc}) of length 1.

An object of class \code{sf} (inherits from \code{tbl_df}, \code{tbl}, \code{data.frame}) with 131 rows and 9 columns.

An object of class \code{sf} (inherits from \code{tbl_df}, \code{tbl}, \code{data.frame}) with 715 rows and 7 columns.
}
\source{
Australian Bureau of Statistics. "Australian Statistical Geography Standard (ASGS) Edition 3." ABS, Jul2021-Jun2026,
\url{https://www.abs.gov.au/statistics/standards/australian-statistical-geography-standard-asgs-edition-3/jul2021-jun2026}, accessed 27 September 2022.

The original dataset is published under the \href{https://creativecommons.org/licenses/by/4.0/}{Creative Commons Attribution 4.0 International} licence, © Commonwealth of Australia 2021.
}
\usage{
nsw

lga_nsw

poa_nsw
}
\description{
Excludes the borders with the ACT and Jervis Bay Territory, and Lord Howe Island.
}
\details{
The geometries have been simplified with a tolerance of 1 km to reduce the
level of detail.
}
\section{Functions}{
\itemize{
\item \code{nsw}: External boundaries of New South Wales as a multipolygon.

\item \code{lga_nsw}: Local Government Area boundaries of New South Wales.

\item \code{poa_nsw}: Postal area boundaries of New South Wales.

}}
\examples{
library(ggplot2)
ggplot(lga_nsw) + geom_sf(aes(fill = LGA_NAME_2021), show.legend = FALSE)

library(sf)
sf_use_s2(FALSE)
# cut out part of the postcode dataset (it's quite large)
bbox <- st_bbox(c(xmin = 142, xmax = 147, ymin = -33, ymax = -30)) |>
 st_as_sfc(crs = crs_gda2020())
st_crop(poa_nsw, bbox) |>
  ggplot() +
  geom_sf() +
  geom_sf_text(aes(label = POA_CODE_2021), size = 4)
}
\keyword{datasets}
