% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api_calls_authentification.R
\name{get_travel_advise}
\alias{get_travel_advise}
\title{Get travel advise from one station to another station}
\usage{
get_travel_advise(fromStation, toStation, dateTime = NULL,
  departure = TRUE, yearCard = FALSE, hslAllowed = FALSE,
  previousAdvises = 4, nextAdvises = 4)
}
\arguments{
\item{fromStation}{the station to start from, for instance "Rotterdam Centraal"}

\item{toStation}{the station to end, for instance "Utrecht Centraal"}

\item{dateTime}{defaults to current time, but you can use a different one: f.i. 2012-02-21T15:50, You can also use the \code{datetime()} function.}

\item{departure}{is the datetime the start or end time? do you want to depart on that date or arrive, defaults to departure}

\item{yearCard}{if you have a NS year card (jaarabonnement) some trips will be different}

\item{hslAllowed}{use of the high speed train}

\item{previousAdvises}{how many advices do you want before the time}

\item{nextAdvises}{how many advises do you want after}
}
\value{
A dataframe with travel advises around your chosen date time. Date time columns are formatted as time in "Europe/Amsterdam" timezone.
}
\description{
This is equivalent to the \href{https://www.ns.nl/reisplanner#/}{NS reisplanner},
you give in a from and to station, the timestamp, if you want the time
to be your departure or arrival time, and optionally if you have a NS year
card (has effect on some travels).
}
\details{
You can also specify how many trips before and after the chosen time you
want to collect (defaults to 4, maximum is 5 before, and 5 after).

Some things to consider: station names need to be in Dutch but the NS
webservice also accepts shortened versions: "Utrecht Centraal" and
"ut" is apparently the same.
Station names can be found with the \code{get_stationlist()} call.

Although the documentation
\url{https://www.ns.nl/en/travel-information/ns-api/documentation-travel-recommendations.html}
is in English, the returned values are all in Dutch. And I keep the results
in Dutch.
}
\examples{
\dontrun{
get_travel_advise("Amsterdam Centraal",
"Utrecht Centraal",dateTime = "2018-08-01T15:21",departure = TRUE)
}
}
