\name{svarmod}
\alias{sb.iso-class}
\alias{svarmod}
\alias{svarmod.sb.iso}
\alias{svarmodels}
\title{Define a (semi)variogram model}
\usage{
  svarmod(model, type = "isotropic", par = NA,
    nugget = NULL, sill = NULL, range = NULL)

  svarmod.sb.iso(dk, x, z, nu, range, sill = nu)

  svarmodels(type = "isotropic")
}
\arguments{
  \item{model}{string indicating the variogram family (see
  Details below).}

  \item{type}{string indicating the type of variogram, e.g.
  "isotropic".}

  \item{par}{vector of variogram parameters.}

  \item{nugget}{nugget value \eqn{c_0}.}

  \item{sill}{variance \eqn{\sigma^2} or sill of the
  variogram (NA for unbounded variograms).}

  \item{range}{range (practical range or scale parameter)
  of the variogram (NA for unbounded variograms; maybe a
  vector for anisotropic variograms).}

  \item{dk}{dimension of the kappa function.}

  \item{x}{discretization nodes.}

  \item{z}{jumps (of the spectral distibution) at the
  discretization nodes.}

  \item{nu}{parameter \eqn{\nu_0} (can be thought of as the
  sill).}
}
\value{
  \code{svarmod} returns an
  \code{svarmod}-\code{\link{class}} object, a list with
  function arguments as components.

  \code{svarmod.sb.iso} returns an S3 object of
  \code{\link{class}} \code{sb.iso} (extends
  \code{svarmod}) corresponding to a `nonparametric'
  isotropic Shapiro-Botha model.

  \code{svarmodels} returns a named character vector with
  the available models of the corresponding \code{type}
  (when appropriate, component values could be used as
  \code{cov.model} argument in \pkg{geoR} routines and
  component names as \code{model} argument in \pkg{gstat}
  routines).
}
\description{
  Defines a variogram model specifying the parameter
  values. Constructor function of the
  \code{svarmod}-\code{\link{class}}.
}
\note{
  \code{svarmod} does not check the consistency of the
  parameter values.
}
\references{
  Shapiro, A. and Botha, J.D. (1991) Variogram fitting with
  a general class of conditionally non-negative definite
  functions. \emph{Computational Statistics and Data
  Analysis}, \bold{11}, 87-96.
}
\seealso{
  \code{\link{sv}}, \code{\link{covar}}.
}

