% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/npc.R
\name{npc}
\alias{npc}
\title{Construct a Neyman-Pearson Classifier from a sample of class 0 and class 1.}
\usage{
npc(x = NULL, y, method = c("logistic", "penlog", "svm", "randomforest",
  "lda", "nb", "ada", "tree", "custom"), alpha = 0.05, delta = 0.05,
  split = 1, split.ratio = 0.5, n.cores = 1, band = FALSE,
  randSeed = 0, ...)
}
\arguments{
\item{x}{n * p observation matrix. n observations, p covariates.}

\item{y}{n 0/1 observatons.}

\item{method}{base classification method.
\itemize{
\item logistic: Logistic regression. \link{glm} function with family = 'binomial'
\item penlog: Penalized logistic regression with LASSO penalty. \code{\link[glmnet]{glmnet}} in \code{glmnet} package
\item svm: Support Vector Machines. \code{\link[e1071]{svm}} in \code{e1071} package
\item randomforest: Random Forest. \code{\link[randomForest]{randomForest}} in \code{randomForest} package
\item Linear Discriminant Analysis. lda: \code{\link[MASS]{lda}} in \code{MASS} package
\item nb: Naive Bayes. \code{\link[e1071]{naiveBayes}} in \code{e1071} package
\item ada: Ada-Boost. \code{\link[ada]{ada}} in \code{ada} package
}}

\item{alpha}{the desirable upper bound on type I error. Default = 0.05.}

\item{delta}{the violation rate of the type I error. Default = 0.05.}

\item{split}{the number of splits for the class 0 sample. Default = 1. For ensemble
version, choose split > 1.}

\item{split.ratio}{the ratio of splits used for the class 0 sample to train the
base classifier. The rest are used to estimate the threshold. Default = 0.5.}

\item{n.cores}{number of cores used for parallel computing. Default = 1. WARNING:
windows machine is not supported.}

\item{band}{whether to generate both lower and upper bounds of type II error. Default #' = FALSE.}

\item{randSeed}{the random seed used in the algorithm.}

\item{...}{additional arguments.}
}
\value{
An object with S3 class npc.
 \item{fits}{a list of length max(1,split), represents the fit during each split.}
 \item{method}{the base classification method.}
  \item{split}{the number of splits used.}
}
\description{
Given a type I error upper bound alpha and a violation upper bound delta, \code{npc} calculates the Neyman-Pearson Classifier
which controls the type I error under alpha with probability at least 1-delta.
}
\examples{
set.seed(1)
n = 1000
x = matrix(rnorm(n*2),n,2)
c = 1+3*x[,1]
y = rbinom(n,1,1/(1+exp(-c)))
xtest = matrix(rnorm(n*2),n,2)
ctest = 1+3*xtest[,1]
ytest = rbinom(n,1,1/(1+exp(-ctest)))

##Use lda classifier and the default type I error control with alpha=0.05, delta=0.05
fit = npc(x, y, method = 'lda')
pred = predict(fit,xtest)
fit.score = predict(fit,x)
accuracy = mean(pred$pred.label==ytest)
cat('Overall Accuracy: ',  accuracy,'\\n')
ind0 = which(ytest==0)
typeI = mean(pred$pred.label[ind0]!=ytest[ind0]) #type I error on test set
cat('Type I error: ', typeI, '\\n')

##Ensembled lda classifier with split = 11,  alpha=0.05, delta=0.05
#fit = npc(x, y, method = 'lda', split = 11)
#pred = predict(fit,xtest)
#accuracy = mean(pred$pred.label==ytest)
#cat('Overall Accuracy: ',  accuracy,'\\n')
#ind0 = which(ytest==0)
#typeI = mean(pred$pred.label[ind0]!=ytest[ind0]) #type I error on test set
#cat('Type I error: ', typeI, '\\n')

##Now, change the method to logistic regression and change alpha to 0.1
fit = npc(x, y, method = 'logistic', alpha = 0.1)
pred = predict(fit,xtest)
accuracy = mean(pred$pred.label==ytest)
cat('Overall Accuracy: ',  accuracy,'\\n')
ind0 = which(ytest==0)
typeI = mean(pred$pred.label[ind0]!=ytest[ind0]) #type I error on test set
cat('Type I error: ', typeI, '\\n')

##Now, change the method to adaboost
#fit = npc(x, y, method = 'ada', alpha = 0.1)
#pred = predict(fit,xtest)
#accuracy = mean(pred$pred.label==ytest)
#cat('Overall Accuracy: ',  accuracy,'\\n')
#ind0 = which(ytest==0)
#typeI = mean(pred$pred.label[ind0]!=ytest[ind0]) #type I error on test set
#cat('Type I error: ', typeI, '\\n')

}
\references{
Xin Tong, Yang Feng, and Jingyi Jessica Li (2016), Neyman-Pearson (NP) classification algorithms and NP receiver operating characteristic (NP-ROC), manuscript, http://arxiv.org/abs/1608.03109.
}
\seealso{
\code{\link{nproc}} and \code{\link{predict.npc}}
}

