% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/removeEarlyDates.R
\name{removeEarlyDates}
\alias{removeEarlyDates}
\title{removeEarlyDates removes dates before a specified year}
\usage{
removeEarlyDates(dates, firstYear)
}
\arguments{
\item{dates}{vector of dates}

\item{firstYear}{integer value of first (earliest) year in the allowed
date range.}
}
\value{
A vector of dates after the year indicated by the numeric value of
\code{firstYear}.
}
\description{
Dates before a specified year are set to NA. This is often used for dates
formed from malformed character representations such as a date in
\%m-\%d-\%Y format being read by \%Y-\%m-\%d format
}
\details{
NA values are ignored and not changed.
}
\examples{
dates <- structure(c(
  12361, 14400, 15413, NA, 11189, NA, 13224, 10971,
  -432000, 13262
), class = "Date")
cleanedDates <- removeEarlyDates(dates, firstYear = 1000)
dates
cleanedDates
}
