% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getTokenList.R
\name{getTokenList}
\alias{getTokenList}
\title{Gets tokens from character vector of lines}
\usage{
getTokenList(lines)
}
\arguments{
\item{lines}{character vector with text from configuration file}
}
\value{
First right and left space trimmed token from first character vector
element.
}
\description{
Gets tokens from character vector of lines
}
\examples{
lines <- c(
  "center = \"SNPRC\"",
  " baseUrl = \"https://boomer.txbiomed.local:8080/labkey\"",
  " schemaName = \"study\"", " folderPath = \"/SNPRC\"",
  " queryName = \"demographics\"",
  "lkPedColumns = (\"Id\", \"gender\", \"birth\", \"death\",",
  "              \"lastDayAtCenter\", \"dam\", \"sire\")",
  "mapPedColumns = (\"id\", \"sex\", \"birth\", \"death\", ",
  "  \"exit\", \"dam\", \"sire\")"
)
lkVec <- c(
  "Id", "gender", "birth", "death",
  "lastDayAtCenter", "dam", "sire"
)
mapVec <- c("id", "sex", "birth", "death", "exit", "dam", "sire")
tokenList <- getTokenList(lines)
params <- tokenList$param
tokenVectors <- tokenList$tokenVec
}
