% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reportGV.R
\name{reportGV}
\alias{reportGV}
\title{Generates a genetic value report for a provided pedigree.}
\usage{
reportGV(
  ped,
  guIter = 5000,
  guThresh = 1,
  pop = NULL,
  byID = TRUE,
  updateProgress = NULL
)
}
\arguments{
\item{ped}{The pedigree information in data.frame format}

\item{guIter}{Integer indicating the number of iterations for the gene-drop
analysis. Default is 5000 iterations}

\item{guThresh}{Integer indicating the threshold number of animals for
defining a unique allele. Default considers an allele "unique"
if it is found in only 1 animal.}

\item{pop}{Character vector with animal IDs to consider as the population of
interest. The default is NULL.}

\item{byID}{Logical variable of length 1 that is passed through to
eventually be used by \code{alleleFreq()}, which calculates the count of each
 allele in the provided vector. If \code{byID} is TRUE and ids are provided,
 the function will only count the unique alleles for an individual
  (homozygous alleles will be counted as 1).}

\item{updateProgress}{Function or NULL. If this function is defined, it
will be called during each iteration to update a
\code{shiny::Progress} object.}
}
\value{
A dataframe with the genetic value report. Animals are ranked
in order of descending value.
}
\description{
This is the main function for the Genetic Value Analysis.
}
\examples{
\donttest{
library(nprcgenekeepr)
examplePedigree <- nprcgenekeepr::examplePedigree
breederPed <- qcStudbook(examplePedigree, minParentAge = 2,
                         reportChanges = FALSE,
                         reportErrors = FALSE)
focalAnimals <- breederPed$id[!(is.na(breederPed$sire) &
                                  is.na(breederPed$dam)) &
                                is.na(breederPed$exit)]
ped <- setPopulation(ped = breederPed, ids = focalAnimals)
trimmedPed <- trimPedigree(focalAnimals, breederPed)
probands <- ped$id[ped$population]
ped <- trimPedigree(probands, ped, removeUninformative = FALSE,
                    addBackParents = FALSE)
geneticValue <- reportGV(ped, guIter = 50, # should be >= 1000
                         guThresh = 3,
                         byID = TRUE,
                         updateProgress = NULL)
trimmedGeneticValue <- reportGV(trimmedPed, guIter = 50, # should be >= 1000
                                guThresh = 3,
                                byID = TRUE,
                                updateProgress = NULL)
rpt <- trimmedGeneticValue[["report"]]
kmat <- trimmedGeneticValue[["kinship"]]
f <- trimmedGeneticValue[["total"]]
mf <- trimmedGeneticValue[["maleFounders"]]
ff <- trimmedGeneticValue[["femaleFounders"]]
nmf <- trimmedGeneticValue[["nMaleFounders"]]
nff <- trimmedGeneticValue[["nFemaleFounders"]]
fe <- trimmedGeneticValue[["fe"]]
fg <- trimmedGeneticValue[["fg"]]
}

}
