% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/removeUninformativeFounders.R
\name{removeUninformativeFounders}
\alias{removeUninformativeFounders}
\title{Remove uninformative founders.}
\usage{
removeUninformativeFounders(ped)
}
\arguments{
\item{ped}{datatable that is the `Pedigree`. It contains pedigree
information. The fields \code{sire} and \code{dam} are required.}
}
\value{
A reduced pedigree.
}
\description{
Founders (having unknown sire and dam) that appear only one time in a
pedigree are uninformative and can be removed from a pedigree without loss
of information.
}
\examples{
\donttest{
examplePedigree <- nprcgenekeepr::examplePedigree
breederPed <- qcStudbook(examplePedigree, minParentAge = 2,
                         reportChanges = FALSE,
                         reportErrors = FALSE)
probands <- breederPed$id[!(is.na(breederPed$sire) &
                               is.na(breederPed$dam)) &
                               is.na(breederPed$exit)]
ped <- getProbandPedigree(probands, breederPed)
nrow(ped)
p <- removeUninformativeFounders(ped)
nrow(p)
p <- addBackSecondParents(p, ped)
nrow(p)
}

}
