% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.nprcgenekeeprErr.R
\name{summary.nprcgenekeeprErr}
\alias{summary.nprcgenekeeprErr}
\alias{summary.nprcgenekeeprGV}
\title{summary.nprcgenekeeprErr Summary function for class nprcgenekeeprErr}
\usage{
\method{summary}{nprcgenekeeprErr}(object, ...)

\method{summary}{nprcgenekeeprGV}(object, ...)
}
\arguments{
\item{object}{object of class nprcgenekeeprErr and class list}

\item{...}{additional arguments for the \code{summary.default} statement}
}
\value{
Object of class summary.nprcgenekeeprErr

object of class summary.nprcgenekeeprGV
}
\description{
summary.nprcgenekeeprErr Summary function for class nprcgenekeeprErr
}
\examples{
\donttest{
errorList <- qcStudbook(nprcgenekeepr::pedOne, minParentAge = 0,
reportChanges = TRUE,
reportErrors = TRUE)
summary(errorList)
}

\donttest{
examplePedigree <- nprcgenekeepr::examplePedigree
breederPed <- qcStudbook(examplePedigree, minParentAge = 2,
                         reportChanges = FALSE,
                         reportErrors = FALSE)
focalAnimals <- breederPed$id[!(is.na(breederPed$sire) &
                                  is.na(breederPed$dam)) &
                                is.na(breederPed$exit)]
ped <- setPopulation(ped = breederPed, ids = focalAnimals)
trimmedPed <- trimPedigree(focalAnimals, breederPed)
probands <- ped$id[ped$population]
ped <- trimPedigree(probands, ped, removeUninformative = FALSE,
                    addBackParents = FALSE)
geneticValue <- reportGV(ped, guIter = 50, # should be >= 1000
                         guThresh = 3,
                         byID = TRUE,
                         updateProgress = NULL)
trimmedGeneticValue <- reportGV(trimmedPed, guIter = 50, # should be >= 1000
                                guThresh = 3,
                                byID = TRUE,
                                updateProgress = NULL)
summary(geneticValue)
summary(trimmedGeneticValue)
}
}
