% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getIdsWithOneParent.R
\name{getIdsWithOneParent}
\alias{getIdsWithOneParent}
\title{getIdsWithOneParent extracts IDs of animals pedigree without either a
sire or a dam}
\usage{
getIdsWithOneParent(uPed)
}
\arguments{
\item{uPed}{a trimmed pedigree dataframe with uninformative founders removed.}
}
\value{
Character vector of all single parents
}
\description{
getIdsWithOneParent extracts IDs of animals pedigree without either a
sire or a dam
}
\examples{
\donttest{
examplePedigree <- nprcgenekeepr::examplePedigree
breederPed <- qcStudbook(examplePedigree, minParentAge = 2,
                         reportChanges = FALSE,
                         reportErrors = FALSE)
probands <- breederPed$id[!(is.na(breederPed$sire) &
                               is.na(breederPed$dam)) &
                               is.na(breederPed$exit)]
ped <- getProbandPedigree(probands, breederPed)
nrow(ped)
p <- removeUninformativeFounders(ped)
nrow(p)
p <- addBackSecondParents(p, ped)
nrow(p)
}
}
