% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nest_drop_na.R
\name{nest_drop_na}
\alias{nest_drop_na}
\title{Drop rows containing missing values in a column of nested data frames}
\usage{
nest_drop_na(.data, .nest_data, ...)
}
\arguments{
\item{.data}{A data frame, data frame extension (e.g., a tibble), or a lazy
data frame (e.g., from dbplyr or dtplyr).}

\item{.nest_data}{A list-column containing data frames}

\item{...}{Columns within \code{.nest_data} to inspect for missing values. If empty,
all columns within each dataframe in \code{.nest_data} are used.}
}
\value{
An object of the same type as \code{.data}. Each object in the column \code{.nest_data}
will have rows dropped according to the presence of NAs.
}
\description{
\code{nest_drop_na()} is used to drop rows from each data frame in a column of
nested data frames.
}
\details{
\code{nest_drop_na()} is a wrapper for \code{\link[tidyr:drop_na]{tidyr::drop_na()}} and maintains the functionality
of \code{drop_na()} within each nested data frame. For more information on \code{drop_na()}
please refer to the documentation in \href{https://tidyr.tidyverse.org/}{'tidyr'}.
}
\examples{
gm <- gapminder::gapminder 

# randomly insert NAs into the dataframe & nest
set.seed(123) 
gm <- gm \%>\% mutate(pop = if_else(runif(nrow(gm)) >= 0.9, NA_integer_, pop))
gm_nest <- gm \%>\% tidyr::nest(country_data = -continent)

# drop rows where an NA exists in column `pop`
gm_nest \%>\% nest_drop_na(.nest_data = country_data,pop)
}
\seealso{
Other tidyr verbs: 
\code{\link{nest_extract}()},
\code{\link{nest_fill}()},
\code{\link{nest_replace_na}()},
\code{\link{nest_separate}()},
\code{\link{nest_unite}()}
}
\concept{tidyr verbs}
