#' Example survey data regarding job satisfaction
#' 
#' A toy dataset containing 500 responses to a job satisfaction survey. The 
#' responses were randomly generated using the Qualtrics survey platform. 
#' 
#' @format A data frame with 500 rows and 6 variables:
#' \describe{
#'   \item{survey_name}{name of survey}
#'   \item{Q1}{respondent age}
#'   \item{Q2}{city the respondent resides in}
#'   \item{Q3}{field that the respondent that works in}
#'   \item{Q4}{respondent's job satisfaction (on a scale from extremely satisfied to extremely dissatisfied)}
#'   \item{Q5}{respondent's annual salary, in thousands of dollars}
#' }
#' 
"job_survey"

#' Example survey data regarding personal life satisfaction
#' 
#' A toy dataset containing 750 responses to a personal satisfaction survey. The 
#' responses were randomly generated using the Qualtrics survey platform.
#' 
#' @format A data frame with 750 rows and 6 variables
#' \describe{
#'   \item{survey_name}{name of survey}
#'   \item{Q1}{respondent age}
#'   \item{Q2}{city the respondent resides in}
#'   \item{Q3}{field that the respondent that works in}
#'   \item{Q4}{respondent's personal life satisfaction (on a scale from extremely satisfied to extremely dissatisfied)}
#'   \item{Q5}{open text response elaborating on personal life satisfaction}
#' }
#' 
"personal_survey"