% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NpdeRes-methods.R
\docType{methods}
\name{gof.test}
\alias{gof.test}
\alias{gof.test.default}
\alias{gof.test.numeric}
\alias{gof.test.NpdeRes}
\alias{printgoftest}
\alias{gof.test.NpdeObject}
\title{Goodness-of-fit tests for npde}
\usage{
gof.test(object, parametric = TRUE, ...)

printgoftest(object, ...)
}
\arguments{
\item{object}{an object (currently has methods for types numeric, NpdeRes and NpdeObject)}

\item{parametric}{a boolean. If TRUE (default), parametric tests are performed}

\item{\dots}{additional arguments passed on to the function; special arguments are \code{na.action}, which controls how to handle NAs in the results (\code{\link{na.action}}), \code{verbose} (if FALSE, suppresses printing of the results) and \code{covsplit} which requests the tests to be performed split by categories or quantiles of the data. If \code{covsplit} is TRUE, continuous covariates will be split in 3 categories (<Q1, Q1-Q3, >Q3) (see details in the PDF documentation), but this behaviour can be overriden by passing the argument \code{ncat=XXX} where XXX is the number of categories to divide the continuous covariates in.}
}
\value{
A list with the following elements:
\describe{
\item{mean}{mean}
\item{se.mean}{standard error of the mean}
\item{var}{variance}
\item{se.var}{standard error on variance}
\item{kurtosis}{kurtosis (see \code{\link{kurtosis}})}
\item{skewness}{skewness (see \code{\link{skewness}})}
\item{p.value}{p-values for several tests (see below)}
}
}
\description{
Performs test on the selected variable (which=one of npde, pd or npd) or on a numeric vector
}
\details{
If object is an NpdeObject and an argument covsplit=TRUE is given in \dots, in addition to the global descriptive statistics and tests, tests will be performed for each covariate in \code{which.cov}. This argument can be set in \dots; barring an explicit specification, the component \code{which.cov} of the prefs slot for a NpdeObject object will be used. The default value is \code{which.cov="all"}, which produces tests for each covariate in the dataset. Two additional dataframes will then be present:
\describe{
\item{cov.stat}{descriptive statistics and test p-values split by covariate and by categories}
\item{cov.p.value}{p-values split by covariate; for each covariate, two tests are performed: the first test is a correlation test for continuous covariates and a Chi-square test for categorical covariates; the second test is defined using the p-values of the global tests split by each category, and appling a Bonferroni correction to obtain an overall p-value (see PDF documentation for details)}
}
The p.value elements is a named vector with four components:
\describe{
\item{p.mean}{p-value for the mean test (Wilcoxon test if parametric=FALSE, Student test if parametric=TRUE)}
\item{p.var}{p-value for the variance test (parametric=FALSE, Fisher test if parametric=TRUE)}
\item{p.dist}{p-value for the distribution test (Shapiro-test for normality (npd, npde)/Kolmogorove-Smirnov test for uniformity)}
\item{p.global}{p-value for the global test (combination of the mean, variance and distribution tests with a Bonferroni correction)}
}
The p-values are adjusted using a Bonferroni correction: the raw p-values of the 3 individual tests are multiplied by 3, and the p-value for the global test is equal to the minimum of the adjusted p-values.
}
\examples{
\donttest{
data(theopp)
data(simtheopp)
#' # Calling autonpde with dataframes
x<-autonpde(theopp,simtheopp,1,3,4,boolsave=FALSE)
gof.test(x)
}
}
\references{
K. Brendel, E. Comets, C. Laffont, C. Laveille, and F. Mentre. Metrics for external model evaluation with an application to the population pharmacokinetics of gliclazide. \emph{Pharmaceutical Research}, 23:2036--49, 2006.

K. Brendel, E. Comets, C. Laffont, and F. Mentre. Evaluation of different tests based on observations for external model evaluation of  population analyses. \emph{Journal of Pharmacokinetics and Pharmacodynamics}, 37:49--65, 2010.
}
\seealso{
\code{\link{kurtosis}}, \code{\link{skewness}}
}
\keyword{methods}
\keyword{test}
