% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/penalties.R
\name{aic.penalty}
\alias{aic.penalty}
\title{Akaike Information Criterion penalty}
\usage{
aic.penalty(n, n.param, ...)
}
\arguments{
\item{n}{The number of observations.}

\item{n.param}{The number of parameters in the model for which the penalty is evaluated.}

\item{...}{Not in use.}
}
\value{
The penalty term \eqn{2 \times \code{n.param}}{2*n.param}.
}
\description{
The function evaluates the penalty term for Akaike Information Criterion. 
This routine is typically not called directly by the user; its name can be passed as an argument to \code{\link{features}}.
}
\examples{
#*** a simple example how to use the AIC penalty
x <- rnorm(300) + c(rep(1,50),rep(0,250))
w <- not(x)
w.cpt <- features(w, penalty="aic")
w.cpt$cpt[[1]]
}
\references{
R. Baranowski, Y. Chen, and P. Fryzlewicz (2016). Narrowest-Over-Threshold Change-Point Detection.  (\url{http://personal.lse.ac.uk/baranows/not/not.pdf})
}

