% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/norm_tidy_dbf.R
\name{norm_tidy_dbf}
\alias{norm_tidy_dbf}
\title{Title: Tidy and Normalize .dbf files obtained from experiments using the FLUOstar microplate reader.}
\usage{
norm_tidy_dbf(file = NULL, fun = NA, ...)
}
\arguments{
\item{file}{A string ("x.dbf) or path directly pointing to a .dbf file}

\item{fun}{A variable defined as NA, used for boolean expressions}

\item{...}{A sequence of dots}
}
\value{
Normalized dataframe with a Time and Cycle_No column
}
\description{
Normalize a tidy dbf data frame. Specific to FLUOstar dirty dbf files. Version 2 will also address .dat files.
}
\examples{
fpath <- system.file("extdata", "liposomes_214.dbf", package = "normfluodbf", mustWork = TRUE)
normalized_dbf <- norm_tidy_dbf(file=fpath)
}
