% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get-change.R
\name{get_change}
\alias{get_change}
\title{Get geo code changes with API}
\usage{
get_change(
  type = c("fylke", "kommune", "bydel", "grunnkrets"),
  from = NULL,
  to = NULL,
  code = TRUE,
  quiet = FALSE,
  date = FALSE
)
}
\arguments{
\item{type}{Type of regional granularity ie. fylke, kommune etc.}

\item{from}{Specify the starting year for range period. Current year is the
default.}

\item{to}{Specify the year to end the range period. Current year is used when
not specified.}

\item{code}{TRUE will only track code changes. Else change name only will
also be considered as change.}

\item{quiet}{TRUE will suppress messages when no changes happened for a
specific time range}

\item{date}{If TRUE then give complete date else year only}
}
\value{
A dataset of class \code{data.table} consisting old and new code with
the respective year when the codes have changed
}
\description{
This function will download all geographical code changes from
SSB via API except enumeration areas (\emph{grunnkrets}) between 1980 to
2001. The code change can be found in the dataset \code{GrunnkretsBefore2002}.

Basically the downloaded data are those you can see directly
\href{https://www.ssb.no/klass/klassifikasjoner/131/endringer}{here}, for
example if you looking for code change in municipality (\emph{kommune}).
The advantage of using \code{get_change} or
\href{https://data.ssb.no/api/klass/v1/api-guide.html#_changes}{KLASS} is
that you can get all code changes for several years at once.
}
\examples{
DT <- get_change("kommune", from = 2018, to = 2020)
}
