\name{plothomol}
\alias{plothomol}
\title{
Marks homologue series peaks in a scatterplot of retention time (RT) vs. m/z
}
\description{
Given results from \code{\link[nontarget]{homol.search}}, a scatterplot of peaks within m/z and RT is generated with homologue series marked.
Herein, homologue series receive a color code based on the mean m/z differences between adjacent peaks of a series; these differences 
are rounded up to the second digit.
}
\usage{
plothomol(homol, xlim = FALSE, ylim = FALSE,plotlegend=TRUE)
}

\arguments{
  \item{homol}{
	List of type homol produed by \code{\link[nontarget]{homol.search}}.
	}
  \item{xlim}{
	\code{xlim=c(upper bound,lower bound)}, default = FALSE.	
	}
  \item{ylim}{
	\code{ylim=c(upper bound,lower bound)}, default = FALSE.
	}
  \item{plotlegend}{
	Should a listing of m/z differences within homologue series and the concommittant color codes been added to the plot? If not, set to FALSE.
	}
	
}
\author{
Martin Loos
}

\seealso{
	\code{\link[nontarget]{homol.search}}
}
\examples{
\donttest{
data(peaklist);
data(iso_list)
homol<-homol.search(
  peaklist,
  iso_list,
  minmz=6,
  maxmz=60,
  minrt=0.5,
  maxrt=1.8,
  ppm=TRUE,
  mztol=3.5,
  rttol=0.4,
  minlen=5,
  plotit=TRUE,
  restr=FALSE
);
plothomol(homol,xlim=FALSE,ylim=FALSE,plotlegend=FALSE);
}
}

