% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{update.nonprob}
\alias{update.nonprob}
\title{The update method for the nonprob object with changed arguments or parameters}
\usage{
\method{update}{nonprob}(object, ..., evaluate = TRUE)
}
\arguments{
\item{object}{the \code{nonprob} class object}

\item{...}{arguments passed to the \code{nonprob} class object}

\item{evaluate}{If true evaluate the new call else return the call}
}
\value{
returns a \code{nonprob} object
}
\description{
The \code{update} method for the \code{nonprob} class object that allows to re-estimate
a given model with changed parameters. This is in particular useful if a user
would like to change method or estimate standard errors if they were not
estimated in the first place.
}
\examples{

data(admin)
data(jvs)

jvs_svy <- svydesign(ids = ~ 1,  weights = ~ weight,
strata = ~ size + nace + region, data = jvs)

ipw_est1 <- nonprob(selection = ~ region + private + nace + size,
target = ~ single_shift,
svydesign = jvs_svy,
data = admin, method_selection = "logit", se = FALSE
)

ipw_est1

update(ipw_est1, se = TRUE)

}
\author{
Maciej Beręsewicz
}
