% Generated by roxygen2 (4.0.1): do not edit by hand
\name{llcont}
\alias{llcont}
\title{Individual Log-Likelihoods}
\usage{
llcont(x, ...)
}
\arguments{
\item{x}{a returned object from the function for the object}

\item{\dots}{arguments passed to methods}
}
\value{
An object of class numeric containing individuals' contributions to the log-likelihood.  The sum of these contributions equals the model log-likelihood.
}
\description{
\code{llcont} returns log-likelihood values associated with individual observations, evaluated at the ML estimates.
}
\details{
This is a s3 generic function:
Currently, the method is defined for lm, glm, glm.nb, clm, hurdle,
zeroinfl, mlogit, nls, polr, rlm, lavaan objects.
}
\examples{
## Gamma
clotting <- data.frame(u = c(5,10,15,20,30,40,60,80,100),
                       lot1 = c(118,58,42,35,27,25,21,19,18),
                       lot2 = c(69,35,26,21,18,16,13,12,12))
gam1 <- glm(lot1 ~ log(u), data = clotting, family = Gamma)
sum(llcont(gam1))
logLik(gam1)
}

