\name{surrogateTest}
\alias{surrogateTest}
\title{Surrogate data testing}
\usage{
  surrogateTest(time.series, significance = 0.05,
    verbose = TRUE, do.plot = TRUE, FUN, ...)
}
\arguments{
  \item{time.series}{The original time.series from which
  the surrogate data is generated.}

  \item{significance}{Significance of the test}

  \item{verbose}{Logical value. If TRUE, a brief summary of
  the test is shown.}

  \item{do.plot}{Logical value. If TRUE, a graphical
  representation of the statistic value for both surrogates
  and original data is shown.}

  \item{FUN}{The function that computes the discriminating
  statistic that shall be used for testing.}

  \item{...}{Additional arguments for the FUN function.}
}
\value{
  A list containing the values of the statistic for the
  surrogates (\emph{surrogates.statistics} field) and the
  value for the original time series
  (\emph{data.statistic})
}
\description{
  Surrogate data testing
}
\details{
  This function tests the null hypothesis (H0) stating that
  the series describes a linear process. The test is
  performed by generating several surrogate data according
  to H0 and comparing the values of a discriminating
  statistic between both original data and the surrogate
  data. If the value of the statistic is significantly
  different for the original series than for the surrogate
  set, the null hypothesis is rejected and nonlinearity
  assumed.  The surrogate data is generated by using a
  phase randomization procedure.
}
\author{
  Constantino A. Garcia
}
\references{
  SCHREIBER, Thomas; SCHMITZ, Andreas. Surrogate time
  series. Physica D: Nonlinear Phenomena, 2000, vol. 142,
  no 3, p. 346-382.
}

