% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eskin.R
\name{eskin}
\alias{eskin}
\title{Eskin (ES) Measure}
\usage{
eskin(data, var.weights = NULL)
}
\arguments{
\item{data}{A data.frame or a matrix with cases in rows and variables in columns.}

\item{var.weights}{A numeric vector setting weights to the used variables. One can choose the real numbers from zero to one.}
}
\value{
The function returns an object of the class "dist".
\cr
}
\description{
The function calculates a dissimilarity matrix based on the ES similarity measure.
}
\details{
The Eskin similarity measure was proposed by Eskin et al. (2002) and examined by Boriah et al., (2008). It is constructed to assign
higher weights to mismatches on variables with more categories.
}
\examples{
# sample data
data(data20)

# dissimilarity matrix calculation
prox.eskin <- eskin(data20)

# dissimilarity matrix calculation with variable weights
weights.eskin <- eskin(data20, var.weights = c(0.7, 1, 0.9, 0.5, 0))

}
\references{
Boriah S., Chandola V., Kumar V. (2008). Similarity measures for categorical data: A comparative evaluation.
In: Proceedings of the 8th SIAM International Conference on Data Mining, SIAM, p. 243-254.
 \cr
 \cr
Eskin E., Arnold A., Prerau M., Portnoy L. and Stolfo S. (2002). A geometric framework for unsupervised anomaly detection.
In D. Barbara and S. Jajodia (Eds): Applications of Data Mining in Computer Security, p. 78-100. Norwell: Kluwer Academic Publishers.
}
\seealso{
\code{\link[nomclust]{anderberg}},
\code{\link[nomclust]{burnaby}},
\code{\link[nomclust]{gambaryan}},
\code{\link[nomclust]{goodall1}},
\code{\link[nomclust]{goodall2}},
\code{\link[nomclust]{goodall3}},
\code{\link[nomclust]{goodall4}},
\code{\link[nomclust]{iof}},
\code{\link[nomclust]{lin}},
\code{\link[nomclust]{lin1}},
\code{\link[nomclust]{of}},
\code{\link[nomclust]{sm}},
\code{\link[nomclust]{smirnov}},
\code{\link[nomclust]{ve}},
\code{\link[nomclust]{vm}}.
}
\author{
Zdenek Sulc. \cr Contact: \email{zdenek.sulc@vse.cz}
}
