% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ratio.R
\name{ratio}
\alias{ratio}
\alias{nom_ratio}
\title{Convert numbers to ratio character vectors (two to one, one in three, five out of ten)}
\usage{
ratio(x, sep = "in", max_n = Inf, negative = "negative", ...)

nom_ratio(x, sep = "in", max_n = Inf, negative = "negative", ...)
}
\arguments{
\item{x}{A numeric vector}

\item{sep}{A character vector separating components of the ratio.
Defaults to \code{"in"}.}

\item{max_n}{A numeric vector.
When the absolute value of \code{x} is greater than \code{max_n}, \code{x} remains
numeric instead of being converted to words.
If \code{max_n} is negative, no \code{x}s will be converted to words.
(This can be useful when \code{max_n} is passed by another function.)
Defaults to \code{Inf}, which converts all \code{x}s to words.}

\item{negative}{A character vector to append to negative numbers.
Defaults to \code{"negative"}.}

\item{...}{
  Arguments passed on to \code{\link[fracture:frac_mat]{fracture::frac_mat}}
  \describe{
    \item{\code{denom}}{If \code{denom} is not \code{\link{NULL}}, all fractions will have a
denominator of \code{denom}. This will ignore all other arguments that affect
the denominator.}
    \item{\code{base_10}}{If \code{TRUE}, all denominators will be a power of 10.}
    \item{\code{common_denom}}{If \code{TRUE}, all fractions will have the same denominator.

If the least common denominator is greater than \code{max_denom},
\code{max_denom} is used.}
    \item{\code{max_denom}}{All denominators will be less than or equal to
\code{max_denom}.

If \code{base_10} is \code{TRUE}, the maximum denominator will be the largest power
of 10 less than \code{max_denom}.

A \code{max_denom} greater than the inverse square root of
\link[=.Machine]{machine double epsilon} will produce a warning because floating
point rounding errors can occur when denominators grow too large.}
  }}
}
\value{
A character vector of the same length as \code{x}
}
\description{
Convert numbers to ratio character vectors (two to one, one in three, five out of ten)
}
\details{
\code{x} is converted to a fraction by \code{\link[fracture:frac_mat]{fracture::frac_mat()}}.
}
\examples{
paste0("Our team is outnumbered ", nom_ratio(10), ".")
paste0("The chances of winning are ", nom_ratio(1/1000000, sep = "in"), ".")

nom_ratio(c(1, 10, 100))
nom_ratio(c(0, 0.5, 1.5))
nom_ratio(c(0, 0.125, 0.625, 1), sep = "out of", common_denom = TRUE)
nom_ratio(5 / 10, sep = "in", base_10 = TRUE)
nom_ratio(6 / 25, sep = "in")
nom_ratio(6 / 25, sep = "out of", max_denom = 10)
}
\seealso{
Other number names: 
\code{\link{adverbial}()},
\code{\link{cardinal}()},
\code{\link{collective}()},
\code{\link{denominator}()},
\code{\link{numerator}()},
\code{\link{ordinal}()}
}
\concept{number names}
