% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Main.R
\name{main_noisySBM}
\alias{main_noisySBM}
\title{Graph Inference from Noisy Data by Multiple Testing}
\usage{
main_noisySBM(
  X,
  NIG = FALSE,
  threshold = 0.5,
  Nbrepet = 2,
  rho = NULL,
  tau = NULL,
  a = NULL,
  b = NULL,
  c = NULL,
  d = NULL,
  n0 = 1,
  eta0 = 1,
  zeta0 = 1,
  alpha = 0.1,
  Qup = NULL,
  nbCores = parallel::detectCores(),
  nbOfZ = 12,
  sigma0 = 1,
  sigma1 = 1,
  percentageOfPerturbation = 0.3,
  verbatim = TRUE
)
}
\arguments{
\item{X}{A p-square matrix containing the data}

\item{NIG}{A Boolean. If FALSE (by default), the variance under the alternative hypothesis in assumed to be known. If TRUE, the variances under the alternatives are unknown and estimated with the NIG method}

\item{threshold}{Threshold use when updating the latent graphs structure from l-values (by default threshold=0.5)}

\item{Nbrepet}{Number of times the algorithm is repeated (by default Nbrepet=2)}

\item{rho}{Hyperparameter of the non-NIG method (by default rho=1)}

\item{tau}{Hyperparameter of the non-NIG method (by default tau=1)}

\item{a}{Hyperparameter of the NIG method (by default a=0)}

\item{b}{Hyperparameter of the NIG method (by default b=1)}

\item{c}{Hyperparameter of the NIG method (by default c=1)}

\item{d}{Hyperparameter of the NIG method (by default d=1)}

\item{n0}{Hyperparameter (by default n0=1)}

\item{eta0}{Hyperparameter (by default eta0=1)}

\item{zeta0}{Hyperparameter (by default zeta0=1)}

\item{alpha}{Level of significance of the multiple testing procedure (by default alpha=0.1)}

\item{Qup}{Maximal number of cluster (by default Qup =10)}

\item{nbCores}{Nb of cores to be used during calculations (by default nbCores=parallel::detectCores())}

\item{nbOfZ}{Nb of initialization (by default nbOfZ=12)}

\item{sigma0}{standard deviation under the null hypothesis (by default sigma0=1)}

\item{sigma1}{standard deviation under the alternative hypothesis in the non-NIG method (by default sigma1=1)}

\item{percentageOfPerturbation}{perturbation during initialization  (by default percentageOfPerturbation=0.3)}

\item{verbatim}{print information messages}
}
\value{
\item{\code{A}}{the adjacency matrix of the inferred graph}
\item{\code{Z}}{the inferred clustering}
\item{\code{theta}}{the parameters of the noisySBM at the end}
\item{\code{Q}}{the number of clusters at the end}
}
\description{
The \code{main_noisySBM()} function is a core component of the \code{noisysbmGGM} package,
responsible for applying the greedy algorithm to estimate model parameters, perform node clustering,
and conduct a multiple testing procedure to infer the underlying graph. This function is versatile,
offering various options and providing useful outputs for further analysis
}
\examples{
main_noisySBM(NSBMtest$dataMatrix,NIG=TRUE,Qup=10,nbOfZ=1,nbCores=1)
}
