% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.R
\name{docdb_get}
\alias{docdb_get}
\title{Get documents}
\usage{
docdb_get(src, key, limit = NULL, ...)
}
\arguments{
\item{src}{source object, result of call to src}

\item{key}{(character) A key (collection for mongo)}

\item{limit}{(integer) number of records/rows to return. by default
not passed, so you get all results. Only works for CouchDB,
Elasticsearch and MongoDB; ignored for others}

\item{...}{passed on to functions:
\itemize{
\item CouchDB: passed to \code{\link[sofa:db_alldocs]{sofa::db_alldocs()}}
\item Elasticsearch: passed to \code{\link[elastic:Search]{elastic::Search()}}
\item Redis: ignored
\item MongoDB: ignored
\item SQLite: ignored
}}
}
\description{
Get documents
}
\details{
Note that with etcd, you have to prefix a key with a
forward slash.
}
\examples{
\dontrun{
# CouchDB
src <- src_couchdb()
docout <- docdb_create(src, key = "mtcars2", value = mtcars)
docdb_get(src, "mtcars2")
docdb_get(src, "mtcars2", limit = 5)

# Elasticsearch
src <- src_elastic()
if (docdb_exists(src, "iris")) docdb_delete(src, "iris")
docdb_create(src, "iris", iris)
Sys.sleep(2)
docdb_get(src, "iris")
if (docdb_exists(src, "d2")) docdb_delete(src, "d2")
docdb_create(src, "d2", diamonds)
Sys.sleep(3)
docdb_get(src, "d2", limit = 1010)

# Redis
src <- src_redis()
docdb_create(src, "mtcars", mtcars)
docdb_get(src, "mtcars")

# Mongo
src <- src_mongo(collection = "mtcars")
docdb_create(src, "mtcars", mtcars)
docdb_get(src, "mtcars")
docdb_get(src, "mtcars", limit = 4)

# SQLite
src <- src_sqlite()
docdb_create(src, "mtcars", mtcars)
docdb_get(src, "mtcars")
docdb_get(src, "mtcars", limit = 4L)
}
}
