% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dplyr_integration.R
\name{db_compute}
\alias{db_compute}
\alias{db_compute.AthenaConnection}
\title{S3 implementation of \code{db_compute} for Athena}
\usage{
db_compute.AthenaConnection(con, table, sql, ...)
}
\arguments{
\item{con}{A \code{\link{dbConnect}} object, as returned by \code{dbConnect()}}

\item{table}{Table name, if left default noctua will use the default from \code{dplyr}'s \code{compute} function.}

\item{sql}{SQL code to be sent to the data}

\item{...}{passes \code{noctua} table creation parameters: [\code{file_type},\code{s3_location},\code{partition}]
\itemize{
         \item{\code{file_type:} What file type to store data.frame on s3, noctua currently supports ["NULL","csv", "parquet", "json"]. 
                       \code{"NULL"} will let Athena set the file_type for you.}
         \item{\code{s3_location:} s3 bucket to store Athena table, must be set as a s3 uri for example ("s3://mybucket/data/")}
         \item{\code{partition:} Partition Athena table, requires to be a partitioned variable from previous table.}}}
}
\value{
\code{db_compute} returns table name
}
\description{
This is a backend function for dplyr's \code{compute} function. Users won't be required to access and run this function.
}
\examples{
\dontrun{
# Note: 
# - Require AWS Account to run below example.
# - Different connection methods can be used please see `noctua::dbConnect` documnentation

library(DBI)
library(dplyr)

# Demo connection to Athena using profile name 
con <- dbConnect(noctua::athena())

# Write data.frame to Athena table
copy_to(con, mtcars,
        s3_location = "s3://mybucket/data/")
             
# Write Athena table from tbl_sql
athena_mtcars <- tbl(con, "mtcars")
mtcars_filter <- athena_mtcars \%>\% filter(gear >=4)

# create athena with unique table name
mtcars_filer \%>\% 
  compute()

# create athena with specified name and s3 location
mtcars_filer \%>\% 
    compute("mtcars_filer",
            s3_location = "s3://mybucket/mtcars_filer/")

# Disconnect from Athena
dbDisconnect(con)
}
}
\seealso{
\code{\link{AthenaWriteTables}} \code{\link{backend_dbplyr_v2}} \code{\link{backend_dbplyr_v1}}
}
