% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dplyr_integration.R
\name{db_save_query}
\alias{db_save_query}
\alias{db_save_query.AthenaConnection}
\title{S3 implementation of \code{db_save_query} for Athena}
\usage{
db_save_query.AthenaConnection(
  con,
  sql,
  name,
  file_type = c("NULL", "csv", "parquet", "json"),
  s3_location = NULL,
  partition = NULL,
  ...
)
}
\arguments{
\item{con}{A \code{\link{dbConnect}} object, as returned by \code{dbConnect()}}

\item{sql}{SQL code to be sent to the data}

\item{name}{Table name if left default noctua will use default from 'dplyr''s \code{compute} function.}

\item{file_type}{What file type to store data.frame on s3, noctua currently supports ["NULL","csv", "parquet", "json"]. 
\code{"NULL"} will let athena set the file_type for you.}

\item{s3_location}{s3 bucket to store Athena table, must be set as a s3 uri for example ("s3://mybucket/data/")}

\item{partition}{Partition Athena table, requires to be a partitioned variable from previous table.}

\item{...}{other parameters, currently not implemented}
}
\value{
db_save_query returns table name
}
\description{
This is a backend method for dplyr function \code{db_save_query} to creating tables from \code{tbl} using \code{compute} function.
Users won't be required to access and run this function. However users may find it useful to know the extra
parameters \code{db_save_query} provided for \code{compute} function.
}
